<?php
require_once 'config.php';
require_once 'header.php';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $email = $_POST['email'] ?? '';
    $subject = $_POST['subject'] ?? '';
    $message = $_POST['message'] ?? '';

    if (empty($name) || empty($email) || empty($subject) || empty($message)) {
        $error = 'جميع الحقول مطلوبة';
    } else {
        // هنا يمكن إضافة كود لإرسال البريد الإلكتروني
        $success = 'تم إرسال رسالتك بنجاح! سنتواصل معك قريباً';
    }
}
?>

<style>
    /* Custom styles to mimic Tailwind/Shadcn design */
    body { background: #1a202c; } /* A darker background to match theme */
    .contact-section { padding-top: 5rem; padding-bottom: 5rem; }
    .contact-badge {
        background-color: #059669; /* green-600 */
        color: white;
        padding: 0.5rem 1rem;
        border-radius: 9999px; /* full rounded */
        font-weight: 600;
        display: inline-block;
        margin-bottom: 1rem;
    }
    .card-contact {
        background: #2d3748; /* gray-800 */
        border: 1px solid #4a5568; /* gray-700 */
        box-shadow: 0 10px 15px -3px rgba(0,0,0,0.1), 0 4px 6px -2px rgba(0,0,0,0.05); /* shadow-lg */
        transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
    }
    .card-contact:hover {
        transform: scale(1.05);
        box-shadow: 0 20px 25px -5px rgba(0,0,0,0.2), 0 10px 10px -5px rgba(0,0,0,0.1);
    }
    .contact-method-card {
        background: #4a5568; /* gray-700 */
        border-radius: 0.5rem; /* rounded-lg */
        box-shadow: 0 4px 6px -1px rgba(0,0,0,0.1), 0 2px 4px -1px rgba(0,0,0,0.06); /* shadow-md */
        transition: transform 0.3s ease-in-out, box-shadow 0.3s ease-in-out;
    }
    .contact-method-card:hover {
        transform: scale(1.05) rotate(-1deg);
    }
    .contact-icon-circle {
        width: 3rem; /* w-12 */
        height: 3rem; /* h-12 */
        border-radius: 9999px; /* rounded-full */
        display: flex;
        align-items: center;
        justify-content: center;
        margin-left: auto;
        margin-right: auto;
        margin-bottom: 1rem;
    }
    .gradient-green { background: linear-gradient(to right, #10b981, #059669); } /* from-green-500 to-green-600 */
    .gradient-blue { background: linear-gradient(to right, #3b82f6, #2563eb); } /* from-blue-500 to-blue-600 */
    .btn-whatsapp {
        background-color: #059669 !important; /* green-600 */
        border-color: #059669 !important;
        color: white !important;
        width: 100%;
        transition: all 0.3s ease-in-out;
    }
    .btn-whatsapp:hover {
        background-color: #047857 !important; /* green-700 */
        transform: scale(1.05);
    }
    .btn-email {
        border: 1px solid #3b82f6 !important; /* border-blue-500 */
        color: #60a5fa !important; /* text-blue-400 */
        background: transparent !important;
        width: 100%;
        transition: all 0.3s ease-in-out;
    }
    .btn-email:hover {
        background-color: #1e3a8a !important; /* bg-blue-900 */
        color: white !important;
        transform: scale(1.05);
    }
    .feature-item {
        transition: transform 0.3s ease-in-out;
    }
    .feature-item:hover {
        transform: scale(1.1);
    }
    .text-blue-400 { color: #60a5fa !important; }
    .text-green-400 { color: #4ade80 !important; }
    .text-purple-400 { color: #c084fc !important; }

    .btn-book-consult {
        background: linear-gradient(to right, #2563eb, #9333ea) !important; /* from-blue-600 to-purple-600 */
        border: none !important;
        color: white !important;
        padding: 1rem 3rem !important;
        font-size: 1.125rem !important; /* text-lg */
        transition: all 0.3s ease-in-out;
    }
    .btn-book-consult:hover {
        background: linear-gradient(to right, #1d4ed8, #7e22ce) !important; /* hover:from-blue-700 hover:to-purple-700 */
        transform: scale(1.1) rotate(1deg);
        box-shadow: 0 20px 25px -5px rgba(0,0,0,0.2), 0 10px 10px -5px rgba(0,0,0,0.1);
    }
</style>

<section id="contact" class="contact-section px-4 relative overflow-hidden text-white">
    <!-- خلفية متحركة (Simplified) -->
    <div class="position-absolute top-0 start-0 w-100 h-100" style="z-index: -1;">
        <div class="position-absolute" style="top: 20%; left: 25%; width: 12rem; height: 12rem; background: radial-gradient(circle, rgba(59,130,246,0.3) 0%, rgba(168,85,247,0.3) 100%); border-radius: 50%; opacity: 0.3;"></div>
        <div class="position-absolute" style="bottom: 20%; right: 25%; width: 10rem; height: 10rem; background: radial-gradient(circle, rgba(168,85,247,0.4) 0%, rgba(236,72,153,0.4) 100%); border-radius: 50%; opacity: 0.4;"></div>
    </div>

    <div class="container mx-auto position-relative" style="z-index: 10;">
        <div class="text-center mb-5">
            <span class="contact-badge">تواصل معنا</span>
            <h2 class="text-4xl md:text-5xl font-bold text-white mb-3">
                ابدأ رحلتك معنا الآن
            </h2>
            <p class="text-xl text-gray-300 max-w-2xl mx-auto">
                تواصل معنا للحصول على استشارة مجانية وخطة مخصصة لنمو حساباتك
            </p>
        </div>

        <div class="max-w-4xl mx-auto">
            <div class="card card-contact">
                <div class="card-header text-center pb-4">
                    <h5 class="card-title text-2xl font-bold text-white">
                        احصل على استشارة مجانية
                    </h5>
                    <p class="card-text text-gray-300">
                        فريقنا جاهز لمساعدتك في تحقيق أهدافك التسويقية
                    </p>
                </div>
                
                <div class="card-body">
                    <div class="row row-cols-1 row-cols-md-2 g-4 mb-4">
                        <div class="col">
                            <div class="contact-method-card text-center p-4">
                                <div class="contact-icon-circle gradient-green">
                                    <span class="text-white fs-4">📱</span>
                                </div>
                                <h4 class="font-bold text-white mb-2">واتساب</h4>
                                <p class="text-gray-300 mb-3">تواصل معنا مباشرة</p>
                                <a href="https://wa.me/201067761719" class="btn btn-whatsapp">
                                    راسلنا على واتساب
                                </a>
                            </div>
                        </div>
                        
                        <div class="col">
                            <div class="contact-method-card text-center p-4">
                                <div class="contact-icon-circle gradient-blue">
                                    <span class="text-white fs-4">📧</span>
                                </div>
                                <h4 class="font-bold text-white mb-2">البريد الإلكتروني</h4>
                                <p class="text-gray-300 mb-3">راسلنا في أي وقت</p>
                                <a href="mailto:info@smselsory.com" class="btn btn-email">
                                    info@smselsory.com
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="text-center pt-4">
                        <div class="row row-cols-1 row-cols-sm-3 g-3 mb-4">
                            <div class="col feature-item">
                                <div class="text-2xl font-bold text-blue-400 mb-2">⏰</div>
                                <div class="text-sm text-gray-300">استجابة فورية</div>
                            </div>
                            <div class="col feature-item">
                                <div class="text-2xl font-bold text-green-400 mb-2">🎯</div>
                                <div class="text-sm text-gray-300">حلول مخصصة</div>
                            </div>
                            <div class="col feature-item">
                                <div class="text-2xl font-bold text-purple-400 mb-2">💡</div>
                                <div class="text-sm text-gray-300">استشارة مجانية</div>
                            </div>
                        </div>
                        
                        <a href="#" class="btn btn-book-consult">
                            احجز استشارتك المجانية الآن
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Retain existing contact form section below the new content -->
<div class="contact-section py-5">
    <h1 class="text-center mb-5">أو أرسل لنا رسالة</h1>
    
    <div class="row">
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-body">
                    <h3 class="card-title">معلومات الاتصال</h3>
                    <ul class="list-unstyled">
                        <li class="mb-3">
                            <i class="bi bi-geo-alt-fill text-primary me-2"></i>
                            العنوان: القاهرة  مصر 
                        </li>
                        <li class="mb-3">
                            <i class="bi bi-telephone-fill text-primary me-2"></i>
                            الهاتف: 201067761719
                        </li>
                        <li class="mb-3">
                            <i class="bi bi-envelope-fill text-primary me-2"></i>
                            البريد الإلكتروني: info@smselsory.com
                        </li>
                    </ul>
                    
                    <h4 class="mt-4">ساعات العمل</h4>
                    <ul class="list-unstyled">
                        <li>الأحد - الخميس: 9:00 صباحاً - 5:00 مساءً</li>
                        <li>الجمعة - السبت: مغلق</li>
                    </ul>
                </div>
            </div>
            
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">تابعنا</h3>
                    <div class="d-flex gap-3">
                        <a href="https://www.facebook.com/share/15USMeb4tW/?mibextid=wwXIfr" class="text-primary fs-4"><i class="bi bi-facebook"></i></a>
                        <a href="https://www.tiktok.com/@elsoury_marketing?_t=ZS-8xCi32Z13tE&_r=1" class="text-primary fs-4"><i class="bi bi-tiktok"></i></a>
                        <a href="https://youtube.com/@elsoury_marketing?si=veKI3-oVxHL_scun" class="text-primary fs-4"><i class="bi bi-youtube"></i></a>
                        <a href="https://www.instagram.com/elsoury_markting?igsh=Ym1hM3YyNWhraTU3&utm_source=qr" class="text-primary fs-4"><i class="bi bi-instagram"></i></a>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-body">
                    <h3 class="card-title">أرسل لنا رسالة</h3>
                    
                    <?php if ($error): ?>
                        <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
                    <?php endif; ?>
                    
                    <?php if ($success): ?>
                        <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
                    <?php endif; ?>
                    
                    <form method="POST" action="contact.php">
                        <div class="mb-3">
                            <label for="name" class="form-label">الاسم</label>
                            <input type="text" class="form-control" id="name" name="name" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="email" class="form-label">البريد الإلكتروني</label>
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="subject" class="form-label">الموضوع</label>
                            <input type="text" class="form-control" id="subject" name="subject" required>
                        </div>
                        
                        <div class="mb-3">
                            <label for="message" class="form-label">الرسالة</label>
                            <textarea class="form-control" id="message" name="message" rows="5" required></textarea>
                        </div>
                        
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">إرسال الرسالة</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?> 